import os
import sys


libraries = []
for filename in os.listdir("."):
    basename, extension = os.path.splitext(filename)
    if extension != ".txt":
        continue
    library, extension = os.path.splitext(basename)
    if extension != ".index":
        continue
    libraries.append(library)

libraries.sort()

counter = 0
output = open("script.sh", 'w')
for library in libraries:
    script_name = "script_%s.sh" % library
    handle = open(script_name, 'w')
    handle.write("""\
#!/bin/bash
#SBATCH -e ./script_%s.stderr
#SBATCH -o ./script_%s.stdout
#SBATCH --mem=4G
python split_bam.py %s
""" % (library, library, library))
    output.write('sbatch %s\n' % script_name)
    counter += 1
output.close()
print("%d scripts generated; run script.sh to schedule them on Grid Engine" % counter)
